"use client";

import { usePathname } from "next/navigation";
import { useEffect, useState } from "react";
import { Footer } from "./Footer";

export function ConditionalFooter() {
  const pathname = usePathname();
  const [isMounted, setIsMounted] = useState(false);

  useEffect(() => {
    setIsMounted(true);
  }, []);

  // During SSR and initial render, always show footer to avoid hydration mismatch
  // After mount, conditionally hide on profile pages
  if (!isMounted) {
    return <Footer />;
  }

  const isProfilePage = pathname?.startsWith("/profile");

  // Don't render footer on profile pages
  if (isProfilePage) {
    return null;
  }

  return <Footer />;
}



