import { ReactNode } from "react";
import { cn } from "@/lib/classNames";

interface ContainerProps {
  children: ReactNode;
  className?: string;
}

export function Container({ children, className = "" }: ContainerProps) {
  return (
    <div
      className={cn("max-w-[1280px] mx-auto px-4 sm:px-6 md:px-8", className)}
    >
      {children}
    </div>
  );
}
