interface StarRatingProps {
  rating: number;
  reviewCount: number;
  className?: string;
}

export function StarRating({
  rating,
  reviewCount,
  className = "",
}: StarRatingProps) {
  // Format: ★4.9 (969) - one decimal, smaller muted review count
  // Slightly smaller font than name, single line, no wrap
  const formattedRating = rating.toFixed(1);
  const formattedCount = reviewCount.toLocaleString();

  return (
    <div className={`flex items-center gap-0.5 whitespace-nowrap ${className}`}>
      <span
        className="text-xs leading-none"
        style={{ color: "var(--color-yellow-400)" }}
      >
        ★
      </span>
      <span
        className="text-xs font-semibold leading-none"
        style={{ color: "var(--text-primary)" }}
      >
        {formattedRating}
      </span>
      <span
        className="text-xs leading-none"
        style={{ color: "var(--text-muted)" }}
      >
        ({formattedCount})
      </span>
    </div>
  );
}
