import type { Metadata } from "next";
import "../styles/globals.css";
import { ConditionalHeader } from "@/components/navigation/ConditionalHeader";
import { ConditionalFooter } from "@/components/navigation/ConditionalFooter";
import { ReactQueryProvider } from "@/lib/react-query/provider";

export const metadata: Metadata = {
  title: "Fresha - Book Local Selfcare Services",
  description: "Book top-rated salons, barbers, and wellness services",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body
        className="antialiased"
        style={{ backgroundColor: "var(--surface)" }}
      >
        <ReactQueryProvider>
          <ConditionalHeader />
          {children}
          <ConditionalFooter />
        </ReactQueryProvider>
      </body>
    </html>
  );
}
