"use client";

import { useState } from "react";
import { Button } from "@/components/ui/button";
import { LogOut, Trash2 } from "lucide-react";
import { clearAuth } from "@/lib/auth";
import { useRouter } from "next/navigation";
import { routes } from "@/config/routes";
import { DeleteAccountModal } from "@/features/profile/components/DeleteAccountModal";

export default function SettingsPage() {
  const router = useRouter();
  const [showDeleteModal, setShowDeleteModal] = useState(false);

  const handleLogout = () => {
    clearAuth();
    router.push(routes.home);
  };

  const handleDeleteSuccess = () => {
    clearAuth();
    router.push(routes.home);
  };

  return (
    <div className="space-y-6">
      <h1 className="heading-4 text-gray-900">Settings</h1>

      <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
        {/* Delete Account Card */}
        <div className="bg-white rounded-xl border border-gray-200 p-6">
          <div className="flex items-start gap-3 mb-4">
            <div className="w-10 h-10 rounded-full bg-red-50 flex items-center justify-center">
              <Trash2 className="w-5 h-5 text-red-600" />
            </div>
            <div className="flex-1">
              <h2 className="heading-5 text-gray-900 mb-2">Delete account</h2>
              <p className="body-text-sm text-gray-600 mb-4">
                Are you sure you want to leave Fresha?
              </p>
              <Button
                variant="outline"
                onClick={() => setShowDeleteModal(true)}
                className="border-red-300 text-red-600 hover:bg-red-50"
              >
                Delete my account
              </Button>
            </div>
          </div>
        </div>

        {/* Logout Card */}
        <div className="bg-white rounded-xl border border-gray-200 p-6">
          <div className="flex items-start gap-3 mb-4">
            <div className="w-10 h-10 rounded-full bg-gray-50 flex items-center justify-center">
              <LogOut className="w-5 h-5 text-gray-600" />
            </div>
            <div className="flex-1">
              <h2 className="heading-5 text-gray-900 mb-2">Logout</h2>
              <p className="body-text-sm text-gray-600 mb-4">
                Sign out of your account
              </p>
              <Button variant="outline" onClick={handleLogout}>
                <LogOut className="w-4 h-4 mr-2" />
                Logout
              </Button>
            </div>
          </div>
        </div>
      </div>

      {/* Delete Account Modal */}
      <DeleteAccountModal
        open={showDeleteModal}
        onOpenChange={setShowDeleteModal}
        onSuccess={handleDeleteSuccess}
      />
    </div>
  );
}
