"use client";

import { Suspense } from "react";
import { SideNav } from "@/components/navigation/SideNav";
import { ProfileHeader } from "@/components/navigation/ProfileHeader";
import { useRouter } from "next/navigation";
import { ArrowLeft } from "lucide-react";

export default function ProfileLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  const router = useRouter();

  return (
    <>
      {/* Desktop Header and Sidebar */}
      <div className="hidden lg:block">
        <Suspense fallback={<div className="h-20 bg-white border-b border-gray-200" />}>
          <ProfileHeader />
        </Suspense>
      </div>
      <div className="hidden lg:block">
        <SideNav />
      </div>

      {/* Mobile/Tablet Header */}
      <div className="lg:hidden sticky top-0 z-50 bg-white border-b border-gray-200">
        <div className="flex items-center gap-4 px-4 py-4">
          <button
            onClick={() => router.back()}
            className="p-2 hover:bg-gray-100 rounded-full transition-colors"
          >
            <ArrowLeft className="w-5 h-5 text-gray-900" />
          </button>
          <h1 className="text-xl font-bold text-gray-900">Profile</h1>
        </div>
      </div>

      {/* Content */}
      <div className="flex min-h-screen bg-gray-50 lg:pt-20">
        <main className="flex-1 py-4 lg:py-8 lg:ml-64">
          <div className="px-4 sm:px-6 lg:px-8">
            <div className="flex items-start">
              {/* Desktop Spacers */}
              <div className="hidden lg:block w-24 flex-shrink-0"></div>
              <div className="flex-1 lg:mx-8">{children}</div>
              <div className="hidden lg:block w-24 flex-shrink-0"></div>
            </div>
          </div>
        </main>
      </div>
    </>
  );
}
