import curry from 'next/dist/compiled/lodash.curry';
import { COMPILER_NAMES } from '../../../../shared/lib/constants';
import DevToolsIgnorePlugin from '../../plugins/devtools-ignore-list-plugin';
import EvalSourceMapDevToolPlugin from '../../plugins/eval-source-map-dev-tool-plugin';
import { getRspackCore } from '../../../../shared/lib/get-rspack';
function shouldIgnorePath(modulePath) {
    return modulePath.includes('node_modules') || modulePath.endsWith('__nextjs-internal-proxy.cjs') || modulePath.endsWith('__nextjs-internal-proxy.mjs') || // Only relevant for when Next.js is symlinked e.g. in the Next.js monorepo
    modulePath.includes('next/dist');
}
export const base = curry(function base(ctx, config) {
    config.mode = ctx.isDevelopment ? 'development' : 'production';
    config.name = ctx.isServer ? ctx.isEdgeRuntime ? COMPILER_NAMES.edgeServer : COMPILER_NAMES.server : COMPILER_NAMES.client;
    config.target = !ctx.targetWeb ? 'node18.17' // Same version defined in packages/next/package.json#engines
     : ctx.isEdgeRuntime ? [
        'web',
        'es6'
    ] : [
        'web',
        'es6'
    ];
    // https://webpack.js.org/configuration/devtool/#development
    if (ctx.isDevelopment) {
        // `eval-source-map` provides full-fidelity source maps for the
        // original source, including columns and original variable names.
        // This is desirable so the in-browser debugger can correctly pause
        // and show scoped variables with their original names.
        config.devtool = 'eval-source-map';
    } else {
        if (ctx.isEdgeRuntime || ctx.isServer && ctx.serverSourceMaps || // Enable browser sourcemaps:
        ctx.productionBrowserSourceMaps && ctx.isClient) {
            config.devtool = 'source-map';
        } else {
            config.devtool = false;
        }
    }
    if (!config.module) {
        config.module = {
            rules: []
        };
    }
    config.plugins ??= [];
    if (config.devtool === 'source-map' && !process.env.NEXT_RSPACK) {
        config.plugins.push(new DevToolsIgnorePlugin({
            shouldIgnorePath
        }));
    } else if (config.devtool === 'eval-source-map') {
        // We're using a fork of `eval-source-map`
        config.devtool = false;
        if (process.env.NEXT_RSPACK) {
            var _config_output;
            config.plugins.push(new (getRspackCore()).EvalSourceMapDevToolPlugin({
                moduleFilenameTemplate: (_config_output = config.output) == null ? void 0 : _config_output.devtoolModuleFilenameTemplate
            }));
        } else {
            var _config_output1;
            config.plugins.push(new EvalSourceMapDevToolPlugin({
                moduleFilenameTemplate: (_config_output1 = config.output) == null ? void 0 : _config_output1.devtoolModuleFilenameTemplate,
                shouldIgnorePath
            }));
        }
    }
    // TODO: add codemod for "Should not import the named export" with JSON files
    // config.module.strictExportPresence = !isWebpack5
    return config;
});

//# sourceMappingURL=base.js.map