# Deployment Instructions for cPanel

## 📦 What's Included

This zip file contains everything needed to deploy your Next.js application to cPanel.

## 🚀 Deployment Steps

### 1. Extract the ZIP file
Extract all files to your cPanel `public_html` directory (or a subdirectory).

### 2. Set Environment Variables
- Copy `.env.production.example` to `.env.production`
- Edit `.env.production` and fill in your actual production values:
  - `NEXT_PUBLIC_API_BASE_URL` - Your live API URL
  - `NEXT_PUBLIC_STRIPE_PUBLISHABLE_KEY_LIVE` - Your Stripe live key
  - `NEXT_PUBLIC_STRIPE_PUBLISHABLE_KEY_TEST` - Your Stripe test key (optional)

### 3. Install Dependencies
Via SSH or cPanel Terminal, run:
```bash
cd public_html  # or your subdirectory
npm install --production
```

### 4. Build the Application (if needed)
If you need to rebuild:
```bash
npm run build
```

### 5. Start the Server
For production, use a process manager like PM2:
```bash
npm install -g pm2
pm2 start npm --name "nextjs-app" -- start
pm2 save
pm2 startup
```

Or use Node.js directly:
```bash
npm start
```

## 📁 File Structure

- `.next/` - Built application (already included)
- `src/` - Source code
- `public/` - Static assets
- `package.json` - Dependencies
- `next.config.js` - Next.js configuration
- `.env.production` - Environment variables (create from example)

## ⚠️ Important Notes

1. **Node.js Version**: Ensure your cPanel has Node.js 18+ installed
2. **Port**: The app runs on port 3000 by default. Configure your cPanel to proxy requests
3. **Environment**: Make sure `.env.production` is set correctly for production
4. **Build**: The `.next` folder is already built, but you can rebuild if needed

## 🔧 Troubleshooting

- If you get module errors, run `npm install` again
- If build fails, check Node.js version: `node --version` (should be 18+)
- Check logs: `pm2 logs` or check your cPanel error logs


