import type { Config } from "tailwindcss";
import { theme } from "./src/config/theme";

const config: Config = {
  content: ["./src/**/*.{js,ts,jsx,tsx,mdx}"],
  theme: {
    extend: {
      // Colors from theme config
      colors: {
        // Background & Foreground
        background: "var(--background)",
        foreground: "var(--foreground)",

        // Primary Colors
        primary: {
          50: "var(--color-primary-50)",
          100: "var(--color-primary-100)",
          200: "var(--color-primary-200)",
          300: "var(--color-primary-300)",
          400: "var(--color-primary-400)",
          500: "var(--color-primary-500)",
          600: "var(--color-primary-600)",
          700: "var(--color-primary-700)",
          800: "var(--color-primary-800)",
          900: "var(--color-primary-900)",
          950: "var(--color-primary-950)",
        },

        // Secondary Colors
        secondary: {
          50: "var(--color-secondary-50)",
          100: "var(--color-secondary-100)",
          200: "var(--color-secondary-200)",
          300: "var(--color-secondary-300)",
          400: "var(--color-secondary-400)",
          500: "var(--color-secondary-500)",
          600: "var(--color-secondary-600)",
          700: "var(--color-secondary-700)",
          800: "var(--color-secondary-800)",
          900: "var(--color-secondary-900)",
          950: "var(--color-secondary-950)",
        },

        // Gray Scale
        gray: {
          50: "var(--color-gray-50)",
          100: "var(--color-gray-100)",
          200: "var(--color-gray-200)",
          300: "var(--color-gray-300)",
          400: "var(--color-gray-400)",
          500: "var(--color-gray-500)",
          600: "var(--color-gray-600)",
          700: "var(--color-gray-700)",
          800: "var(--color-gray-800)",
          900: "var(--color-gray-900)",
          950: "var(--color-gray-950)",
        },

        // Semantic Colors
        success: {
          50: "var(--color-success-50)",
          100: "var(--color-success-100)",
          500: "var(--color-success-500)",
          600: "var(--color-success-600)",
          700: "var(--color-success-700)",
        },
        warning: {
          50: "var(--color-warning-50)",
          100: "var(--color-warning-100)",
          500: "var(--color-warning-500)",
          600: "var(--color-warning-600)",
          700: "var(--color-warning-700)",
        },
        error: {
          50: "var(--color-error-50)",
          100: "var(--color-error-100)",
          500: "var(--color-error-500)",
          600: "var(--color-error-600)",
          700: "var(--color-error-700)",
        },
        info: {
          50: "var(--color-info-50)",
          100: "var(--color-info-100)",
          500: "var(--color-info-500)",
          600: "var(--color-info-600)",
          700: "var(--color-info-700)",
        },

        // Special Colors
        yellow: {
          400: "var(--color-yellow-400)",
          500: "var(--color-yellow-500)",
        },
        white: "var(--color-white)",
        black: "var(--color-black)",
      },

      // Font Families from theme
      fontFamily: {
        sans: [...theme.typography.fontFamily.sans],
        mono: [...theme.typography.fontFamily.mono],
      },

      // Font Sizes from theme
      fontSize: theme.typography.fontSize,

      // Font Weights from theme
      fontWeight: theme.typography.fontWeight,

      // Line Heights from theme
      lineHeight: theme.typography.lineHeight,

      // Letter Spacing from theme
      letterSpacing: theme.typography.letterSpacing,

      // Border Radius from theme
      borderRadius: theme.borderRadius,

      // Box Shadows from theme
      boxShadow: {
        sm: "var(--shadow-sm)",
        DEFAULT: "var(--shadow-base)",
        md: "var(--shadow-md)",
        lg: "var(--shadow-lg)",
        xl: "var(--shadow-xl)",
        "2xl": "var(--shadow-2xl)",
        inner: "var(--shadow-inner)",
        none: "var(--shadow-none)",
      },

      // Transitions from theme
      transitionDuration: theme.transitions.duration,
      transitionTimingFunction: theme.transitions.easing,

      // Z-Index from theme
      zIndex: theme.zIndex,

      // Component tokens
      width: {
        ...theme.spacing,
        card: "var(--card-width)",
      },
      height: {
        ...theme.spacing,
        "card-image": "var(--card-image-height)",
        "card-min": "var(--card-min-height)",
      },
      minHeight: {
        ...theme.spacing,
        card: "var(--card-min-height)",
      },
      padding: {
        ...theme.spacing,
        "card-x": "var(--card-padding-x)",
        "card-y": "var(--card-padding-y)",
      },
      
      // Animations
      keyframes: {
        "slide-up": {
          "0%": { transform: "translateY(100%)" },
          "100%": { transform: "translateY(0)" },
        },
        "slide-down": {
          "0%": { transform: "translateY(0)" },
          "100%": { transform: "translateY(100%)" },
        },
        "slide-in-right": {
          "0%": { transform: "translateX(100%)" },
          "100%": { transform: "translateX(0)" },
        },
      },
      animation: {
        "slide-up": "slide-up 0.3s ease-out",
        "slide-down": "slide-down 0.3s ease-out",
        "slide-in-right": "slide-in-right 0.3s ease-out",
      },
    },
  },
  plugins: [],
};
export default config;
