/**
 * Stripe Payment Schemas
 */

import { z } from "zod";

// Init Stripe Customer Request
export const InitStripeCustomerRequestSchema = z.object({
  salonId: z.number(),
});

export type InitStripeCustomerRequest = z.infer<
  typeof InitStripeCustomerRequestSchema
>;

// Init Stripe Customer Response
export const InitStripeCustomerResponseSchema = z.object({
  stripeCustomerId: z.string(),
  stripeAccountId: z.string(),
});

export type InitStripeCustomerResponse = z.infer<
  typeof InitStripeCustomerResponseSchema
>;

// Upfront Payment Info Request
export const UpfrontPaymentInfoRequestSchema = z.object({
  onlinePayments: z.boolean(),
  advanceAmount: z.number(),
  stripeCustomerId: z.string(),
  salonId: z.number(),
});

export type UpfrontPaymentInfoRequest = z.infer<
  typeof UpfrontPaymentInfoRequestSchema
>;

// Upfront Payment Info Response
export const UpfrontPaymentInfoResponseSchema = z.object({
  ephemeralKeySecret: z.string(),
  connectionToken: z.string(),
  clientSecret: z.string(),
  paymentIntendId: z.string(),
  initialPayment: z.number(),
  tip: z.number(),
  platformFee: z.number(),
  actualCapturedAmount: z.number(),
  stripeCustomerId: z.string(),
  stripeAccountId: z.string(),
});

export type UpfrontPaymentInfoResponse = z.infer<
  typeof UpfrontPaymentInfoResponseSchema
>;

// Create Setup Intent Request
export const CreateSetupIntentRequestSchema = z.object({
  salonId: z.union([z.number(), z.string()]).transform((val) => 
    typeof val === "string" ? parseInt(val, 10) : val
  ),
});

export type CreateSetupIntentRequest = z.infer<
  typeof CreateSetupIntentRequestSchema
>;

// Create Setup Intent Response
export const CreateSetupIntentResponseSchema = z.object({
  clientSecret: z.string(),
  setupIntentId: z.string(),
  stripeCustomerId: z.string(),
  stripeAccountId: z.string(),
});

export type CreateSetupIntentResponse = z.infer<
  typeof CreateSetupIntentResponseSchema
>;

