/**
 * Zod Schemas for Service entities
 */

import { z } from "zod";

export const ServiceSchema = z.object({
  id: z.string(),
  venueId: z.string(),
  name: z.string(),
  description: z.string().optional(),
  duration: z.number().int().min(1), // Duration in minutes
  price: z.number().min(0),
  currency: z.string().default("USD"),
  category: z.string(),
  image: z.string().url().optional(),
  isActive: z.boolean().default(true),
  requiresConsultation: z.boolean().default(false),
  createdAt: z.string().datetime().optional(),
  updatedAt: z.string().datetime().optional(),
});

export const ServiceCategorySchema = z.object({
  id: z.string(),
  name: z.string(),
  slug: z.string(),
  description: z.string().optional(),
  services: z.array(ServiceSchema).optional(),
});

export type Service = z.infer<typeof ServiceSchema>;
export type ServiceCategory = z.infer<typeof ServiceCategorySchema>;




