/**
 * Zod Schemas for Review entities
 */

import { z } from "zod";

export const ReviewSchema = z.object({
  id: z.string(),
  venueId: z.string(),
  userId: z.string(),
  userName: z.string(),
  userImage: z.string().url().optional(),
  userLocation: z.string().optional(),
  rating: z.number().int().min(1).max(5),
  title: z.string().optional(),
  body: z.string(),
  serviceId: z.string().optional(),
  serviceName: z.string().optional(),
  createdAt: z.string().datetime(),
  updatedAt: z.string().datetime().optional(),
  helpfulCount: z.number().int().min(0).default(0),
  verified: z.boolean().default(false),
});

export type Review = z.infer<typeof ReviewSchema>;




