import { z } from "zod";

export const AvailabilityRequestSchema = z.object({
  openingTime: z.string(), // Format: "HH:mm"
  closingTime: z.string(), // Format: "HH:mm"
  jobDate: z.string(), // Format: "YYYY-MM-DD"
  duration: z.number(), // Duration in minutes
});

export const TimeSlotSchema = z.object({
  start: z.string(), // Format: "HH:MM AM/PM"
  end: z.string(), // Format: "HH:MM AM/PM"
});

export const AvailabilityResponseSchema = z.object({
  status: z.string(),
  message: z.string(),
  data: z.object({
    availableTimeSlots: z.array(TimeSlotSchema),
  }),
  error: z.string(),
});

export type AvailabilityRequest = z.infer<typeof AvailabilityRequestSchema>;
export type TimeSlot = z.infer<typeof TimeSlotSchema>;
export type AvailabilityResponse = z.infer<typeof AvailabilityResponseSchema>;






