/**
 * Account Deletion Schemas
 */

import { z } from "zod";

export const DeletionReasonSchema = z.object({
  id: z.number(),
  reason: z.string(),
});

export const UserDataSchema = z.object({
  email: z.string(),
});

export const GetAccountDeletionReasonsResponseSchema = z.object({
  reasons: z.array(DeletionReasonSchema),
  userData: UserDataSchema,
});

export const DeleteCustomerRequestSchema = z.object({
  reasonId: z.number(),
});

export type DeletionReason = z.infer<typeof DeletionReasonSchema>;
export type UserData = z.infer<typeof UserDataSchema>;
export type GetAccountDeletionReasonsResponse = z.infer<
  typeof GetAccountDeletionReasonsResponseSchema
>;
export type DeleteCustomerRequest = z.infer<
  typeof DeleteCustomerRequestSchema
>;

