/**
 * React Query hook for fetching a single venue
 */

import { useQuery, UseQueryOptions } from "@tanstack/react-query";
import { getVenueClient } from "../api/getVenue";
import { Venue } from "@/lib/schemas/venue";

export interface UseVenueParams {
  slug: string;
}

export function useVenue(
  params: UseVenueParams,
  options?: Omit<
    UseQueryOptions<Venue, Error, Venue, string[]>,
    "queryKey" | "queryFn"
  >
) {
  return useQuery({
    queryKey: ["venue", params.slug],
    queryFn: () => getVenueClient(params),
    ...options,
  });
}




