/**
 * Get Service Types API - Server Side Only
 * Fetches all available service types
 */

import "server-only";
import { z } from "zod";

const ServiceTypeSchema = z.object({
  id: z.number(),
  typeName: z.string(),
  image: z.string(),
  serviceOrder: z.number(),
  status: z.boolean(),
  createdAt: z.string(),
});

const GetServiceTypesResponseSchema = z.object({
  status: z.string(),
  message: z.string(),
  data: z.array(ServiceTypeSchema),
});

export type ServiceType = z.infer<typeof ServiceTypeSchema>;

/**
 * Server-side: Get service types
 */
export async function getServiceTypesServer(): Promise<ServiceType[]> {
  const { serverFetcher } = await import("@/lib/api/fetcher-server");

  const data = await serverFetcher<unknown>("/customer/service-types", {
    requireAuth: false,
    method: "GET",
  });

  const parsed = GetServiceTypesResponseSchema.parse(data);
  return parsed.data;
}






