/**
 * Utility functions for handling salon images
 */

import { API_BASE_URL } from "@/config/env";

/**
 * Convert relative image path to absolute URL
 */
export function getImageUrl(imagePath?: string | null): string {
  if (!imagePath) {
    return "/placeholder-venue";
  }

  if (imagePath.startsWith("http://") || imagePath.startsWith("https://")) {
    return imagePath;
  }

  if (imagePath.startsWith("/")) {
    return `${API_BASE_URL}${imagePath}`;
  }

  // Relative path like "Public/Gallery/..." - prepend base URL with leading slash
  return `${API_BASE_URL}/${imagePath}`;
}

