/**
 * Get Salon Detail API - Server Side
 * Fetches detailed information about a salon
 */

import {
  SalonDetailResponseSchema,
  type SalonDetailResponse,
} from "@/lib/schemas/salonDetail";

/**
 * Server-side: Get salon detail
 * Dynamically imports server fetcher to avoid bundling in client code
 */
export async function getSalonDetailServer(
  salonId: string | number
): Promise<SalonDetailResponse> {
  // Dynamically import server fetcher to avoid bundling in client
  const { serverFetcher } = await import("@/lib/api/fetcher-server");

  const data = await serverFetcher<unknown>(
    `/customer/salon-detail/${salonId}`,
    {
      requireAuth: false,
      method: "GET",
    }
  );

  return SalonDetailResponseSchema.parse(data);
}
