/**
 * Get Salon Availability API - Client Side
 * Fetches available time slots for a salon
 */

"use client";

import { clientFetcher } from "@/lib/api/fetcher-client";
import {
  AvailabilityRequestSchema,
  AvailabilityResponseSchema,
  type AvailabilityRequest,
  type AvailabilityResponse,
} from "@/lib/schemas/availability";

/**
 * Client-side: Get salon availability
 */
export async function getSalonAvailabilityClient(
  salonId: string | number,
  request: AvailabilityRequest
): Promise<{ availableTimeSlots: Array<{ start: string; end: string }> }> {
  const validatedRequest = AvailabilityRequestSchema.parse(request);

  // clientFetcher already extracts data.data, so we get the data object directly
  const data = await clientFetcher<{ availableTimeSlots: Array<{ start: string; end: string }> }>(
    `/customer/salon-availability/salon/${salonId}`,
    {
      requireAuth: false,
      method: "POST",
      body: JSON.stringify(validatedRequest),
    }
  );

  return data;
}

