/**
 * Get Employee Availability API - Client Side
 * Fetches available time slots for a specific employee
 */

"use client";

import { clientFetcher } from "@/lib/api/fetcher-client";
import {
  AvailabilityRequestSchema,
  AvailabilityResponseSchema,
  type AvailabilityRequest,
  type AvailabilityResponse,
} from "@/lib/schemas/availability";

/**
 * Client-side: Get employee availability
 */
export async function getEmployeeAvailabilityClient(
  employeeId: string | number,
  request: AvailabilityRequest
): Promise<{ availableTimeSlots: Array<{ start: string; end: string }> }> {
  const validatedRequest = AvailabilityRequestSchema.parse(request);

  // clientFetcher already extracts data.data, so we get the data object directly
  const data = await clientFetcher<{ availableTimeSlots: Array<{ start: string; end: string }> }>(
    `/customer/employees-availability/employee/${employeeId}`,
    {
      requireAuth: false,
      method: "POST",
      body: JSON.stringify(validatedRequest),
    }
  );

  return data;
}

