/**
 * Create Setup Intent API - Client Side
 * Creates a Setup Intent for saving payment methods without charging
 */

"use client";

import { clientFetcher } from "@/lib/api/fetcher-client";
import {
  CreateSetupIntentRequestSchema,
  CreateSetupIntentResponseSchema,
  type CreateSetupIntentRequest,
  type CreateSetupIntentResponse,
} from "@/lib/schemas/stripe";

/**
 * Client-side: Create Setup Intent
 * Use in Client Components, React Query hooks
 */
export async function createSetupIntentClient(
  request: CreateSetupIntentRequest
): Promise<CreateSetupIntentResponse> {
  // Validate request
  const validatedRequest = CreateSetupIntentRequestSchema.parse(request);

  const data = await clientFetcher<unknown>(
    "/customer/create-setup-intent",
    {
      requireAuth: true,
      method: "POST",
      body: JSON.stringify(validatedRequest),
    }
  );

  return CreateSetupIntentResponseSchema.parse(data);
}


