/**
 * Book Appointment API - Client Side
 * Books an appointment with the salon
 */

"use client";

import { clientFetcher } from "@/lib/api/fetcher-client";
import {
  BookAppointmentRequestSchema,
  type BookAppointmentRequest,
} from "@/lib/schemas/bookAppointment";

/**
 * Client-side: Book appointment
 * Use in Client Components, React Query hooks
 */
export async function bookAppointmentClient(
  request: BookAppointmentRequest
): Promise<unknown> {
  // Validate request
  const validatedRequest = BookAppointmentRequestSchema.parse(request);

  const data = await clientFetcher<unknown>("/customer/book-appointment", {
    requireAuth: true,
    method: "POST",
    body: JSON.stringify(validatedRequest),
  });

  return data;
}





