/**
 * Apply Coupon API - Client Side
 * Applies a discount coupon to a booking
 */

"use client";

import { clientFetcher } from "@/lib/api/fetcher-client";
import {
  ApplyCouponRequestSchema,
  ApplyCouponResponseSchema,
  type ApplyCouponRequest,
  type ApplyCouponResponse,
} from "@/lib/schemas/coupon";

/**
 * Client-side: Apply coupon
 * Use in Client Components, React Query hooks
 */
export async function applyCouponClient(
  request: ApplyCouponRequest
): Promise<ApplyCouponResponse> {
  // Validate request
  const validatedRequest = ApplyCouponRequestSchema.parse(request);

  const data = await clientFetcher<unknown>("/customer/apply-coupon", {
    requireAuth: true,
    method: "POST",
    body: JSON.stringify(validatedRequest),
  });

  return ApplyCouponResponseSchema.parse(data);
}





