/**
 * React Query hook for appointment detail
 */

import { useQuery } from "@tanstack/react-query";
import { getAppointmentDetailClient } from "../api/getAppointmentDetail-client";
import type { GetAppointmentDetailResponse } from "@/lib/schemas/appointmentDetail";

export function useAppointmentDetail(appointmentId: number | null) {
  return useQuery<GetAppointmentDetailResponse>({
    queryKey: ["appointment-detail", appointmentId],
    queryFn: async () => {
      if (!appointmentId) {
        throw new Error("Appointment ID is required");
      }
      return await getAppointmentDetailClient(appointmentId);
    },
    enabled: !!appointmentId,
    staleTime: 2 * 60 * 1000, // 2 minutes
    retry: 1,
  });
}



