/**
 * Delete Customer API - Client Side
 * Deletes the customer account
 */

"use client";

import { clientFetcher } from "@/lib/api/fetcher-client";
import {
  DeleteCustomerRequestSchema,
  type DeleteCustomerRequest,
} from "@/lib/schemas/accountDeletion";

/**
 * Client-side: Delete customer account
 * Use in Client Components, React Query hooks
 */
export async function deleteCustomerClient(
  request: DeleteCustomerRequest
): Promise<unknown> {
  // Validate request
  const validatedRequest = DeleteCustomerRequestSchema.parse(request);

  const data = await clientFetcher<unknown>("/customer/delete-customer", {
    requireAuth: true,
    method: "POST",
    body: JSON.stringify(validatedRequest),
  });

  return data;
}
