/**
 * Verify OTP for Forgot Password API
 * Validates password reset verification code
 */

import { API_BASE_URL } from "@/config/env";
import { getDeviceToken } from "@/lib/deviceToken";

export interface VerifyOtpForgotPasswordRequest {
  otpId: string;
  OTP: string;
}

export interface VerifyOtpForgotPasswordResponse {
  status: string;
  message: string;
  data: {
    otpId: string;
    userId: string;
  };
  error: string;
}

/**
 * Verify OTP for password reset
 * Returns otpId and userId for password reset completion
 */
export async function verifyOtpForgotPassword(
  otpId: string,
  otp: string
): Promise<VerifyOtpForgotPasswordResponse> {
  const response = await fetch(
    `${API_BASE_URL}/customer-auth/verify-otp-forget-password`,
    {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
        Accept: "application/json",
      },
      body: JSON.stringify({
        otpId,
        OTP: otp,
      }),
    }
  );

  const data: VerifyOtpForgotPasswordResponse = await response.json();
  return data;
}




