/**
 * Resend OTP API
 * Resends OTP to user's email for verification
 */

import { API_BASE_URL } from "@/config/env";
import { getDeviceToken } from "@/lib/deviceToken";

export interface ResendOtpRequest {
  email: string;
  userId: string;
}

export interface ResendOtpResponse {
  status: string;
  message: string;
  data: {
    otpId: string;
    userId: string;
  };
  error: string;
}

/**
 * Resend OTP to user's email
 * Returns otpId and userId for verification
 */
export async function resendOtp(
  email: string,
  userId: string
): Promise<ResendOtpResponse> {
  const response = await fetch(`${API_BASE_URL}/customer-auth/resend-otp`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
      Accept: "application/json",
    },
    body: JSON.stringify({
      email,
      userId,
    }),
  });

  const data: ResendOtpResponse = await response.json();
  return data;
}

