import { ReactNode } from "react";
import { cn } from "@/lib/classNames";

interface CardProps {
  children: ReactNode;
  className?: string;
  hover?: boolean;
  style?: React.CSSProperties;
  onClick?: (e: React.MouseEvent<HTMLDivElement>) => void;
  onMouseEnter?: (e: React.MouseEvent<HTMLDivElement>) => void;
  onMouseLeave?: (e: React.MouseEvent<HTMLDivElement>) => void;
}

export function Card({
  children,
  className = "",
  hover = false,
  style,
  onClick,
  onMouseEnter,
  onMouseLeave,
}: CardProps) {
  return (
    <div
      className={cn(
        "bg-surface rounded-[var(--card-border-radius)] overflow-hidden flex flex-col",
        className
      )}
      style={{
        boxShadow: hover ? undefined : "none",
        ...style,
      }}
      onClick={onClick}
      onMouseEnter={onMouseEnter}
      onMouseLeave={onMouseLeave}
    >
      {children}
    </div>
  );
}
