"use client";

import { usePathname } from "next/navigation";
import { useEffect, useState } from "react";
import { Header } from "./Header";

export function ConditionalHeader() {
  const pathname = usePathname();
  const [isMounted, setIsMounted] = useState(false);

  useEffect(() => {
    setIsMounted(true);
  }, []);

  // During SSR and initial render, always show header to avoid hydration mismatch
  // After mount, conditionally hide on profile pages
  if (!isMounted) {
    return <Header />;
  }

  const isProfilePage = pathname?.startsWith("/profile");
  const isSearchPage = pathname?.startsWith("/search");

  // Don't render header on profile and search pages (they have their own ProfileHeader)
  if (isProfilePage || isSearchPage) {
    return null;
  }

  return <Header />;
}



