import { Container } from "@/components/layout/Container";
import { PageSection } from "@/components/layout/PageSection";
import { Button } from "@/components/ui/button";
import Link from "next/link";
import { routes } from "@/config/routes";

export default function BusinessPage() {
  return (
    <main>
      <PageSection>
        <Container>
          <div className="py-20 text-center">
            <h1 className="text-5xl font-bold text-gray-900 mb-6">
              Fresha for Business
            </h1>
            <p className="text-xl text-gray-600 mb-8 max-w-2xl mx-auto">
              The all-in-one booking platform for salons, spas, and wellness professionals.
            </p>
            <Link href={routes.home}>
              <Button>Back to Home</Button>
            </Link>
          </div>
        </Container>
      </PageSection>
    </main>
  );
}




