"use client";

import { useRouter } from "next/navigation";
import { ArrowRight, Globe, Headphones } from "lucide-react";
import Link from "next/link";
import { AuthLayoutSplit } from "@/features/auth/components/AuthLayoutSplit";
import { AuthFooterLinks } from "@/features/auth/components/AuthFooterLinks";
import { routes } from "@/config/routes";

export default function AuthSelectionPage() {
  const router = useRouter();

  return (
    <AuthLayoutSplit>
      <div className="max-w-md mx-auto w-full flex flex-col min-h-full">
        {/* Back Button */}
        <Link
          href={routes.home}
          className="mb-8 p-2 -ml-2 hover:bg-gray-50 rounded-lg transition-colors self-start inline-block"
          aria-label="Go back"
        >
          <ArrowRight className="w-5 h-5 text-gray-900 rotate-180" />
        </Link>

        {/* Title */}
        <h1 className="heading-2 mb-8">Sign up/log in</h1>

        {/* Account Type Cards */}
        <div className="space-y-4 mb-auto">
          <button
            onClick={() => router.push(routes.signup)}
            className="w-full p-6 rounded-xl border border-gray-300 bg-white hover:bg-gray-50 transition-all text-left group"
          >
            <div className="flex items-center justify-between">
              <div>
                <h2 className="card-title mb-1">Fresha for customers</h2>
                <p className="card-text">Book salons and spas near you</p>
              </div>
              <ArrowRight className="w-5 h-5 text-gray-900 group-hover:translate-x-1 transition-transform" />
            </div>
          </button>

          <button
            onClick={() => router.push("/login/professional")}
            className="w-full p-6 rounded-xl border border-gray-300 bg-white hover:bg-gray-50 transition-all text-left group"
          >
            <div className="flex items-center justify-between">
              <div>
                <h2 className="card-title mb-1">Fresha for professionals</h2>
                <p className="card-text">Manage and grow your business</p>
              </div>
              <ArrowRight className="w-5 h-5 text-gray-900 group-hover:translate-x-1 transition-transform" />
            </div>
          </button>
        </div>

        {/* Footer Links */}
        <AuthFooterLinks />
      </div>
    </AuthLayoutSplit>
  );
}

