# Home Page Responsive Implementation Plan
## Tablet & Mobile Device Optimization

**Date:** December 1, 2025  
**Target Devices:** Mobile (320px - 768px), Tablet (768px - 1024px)  
**Reference:** Fresha.com responsive design patterns

---

## Overview

This plan outlines the changes needed to make the home page fully responsive for tablet and mobile devices, matching the design patterns shown in the reference images.

---

## 1. Hero Section (`HeroSection.tsx`)

### Current Issues:
- Search bar uses `md:flex-row` but needs better mobile stacking
- Text sizes may be too large on mobile
- Padding and spacing need mobile optimization
- "Get the app" button needs mobile styling

### Changes Required:

#### 1.1 Search Bar Layout
- **Mobile (< 768px):**
  - Stack all fields vertically (`flex-col`)
  - Remove rounded-full, use rounded-xl for each field
  - Each field should be full width with proper spacing
  - Search button should be full width below all fields
  - Remove dividers between fields
  - Add proper padding between stacked elements

- **Tablet (768px - 1024px):**
  - Keep horizontal layout but allow wrapping
  - Reduce field widths to fit 2-3 fields per row
  - Maintain rounded-full appearance
  - Keep dividers visible

#### 1.2 Typography
- **Mobile:**
  - Reduce heading-hero size (use `text-3xl sm:text-4xl` instead of default)
  - Reduce description text size (`text-sm sm:text-base`)
  - Reduce appointments count text size

- **Tablet:**
  - Use medium heading sizes (`text-4xl md:text-5xl`)
  - Maintain readable description text

#### 1.3 Spacing & Padding
- **Mobile:**
  - Reduce section min-height (`min-h-[50vh] sm:min-h-[60vh]`)
  - Reduce top padding (`pt-12 sm:pt-16`)
  - Reduce bottom padding (`pb-6 sm:pb-8`)
  - Reduce container padding (`px-2 sm:px-4`)

- **Tablet:**
  - Use medium padding values
  - Maintain comfortable spacing

#### 1.4 "Get the app" Button
- **Mobile:**
  - Make button smaller and more compact
  - Reduce padding (`px-4 py-2`)
  - Adjust icon size

---

## 2. Venue Cards (`VenueCard.tsx`)

### Current Issues:
- Card width uses CSS variables that may not scale well
- Image height may be too large on mobile
- Text sizes need mobile optimization

### Changes Required:

#### 2.1 Card Width
- **Mobile:**
  - Use fixed width: `w-[280px] sm:w-[300px]` (instead of CSS variable)
  - Ensure cards don't shrink below minimum width
  - Add proper gap between cards (`gap-3 sm:gap-4`)

- **Tablet:**
  - Use: `w-[320px] md:w-[340px]`
  - Maintain consistent card sizing

#### 2.2 Image Height
- **Mobile:**
  - Reduce image height: `h-[180px] sm:h-[200px]`
  - Maintain aspect ratio

- **Tablet:**
  - Use: `h-[220px] md:h-[240px]`

#### 2.3 Text Sizing
- **Mobile:**
  - Reduce card title size (`text-sm sm:text-base`)
  - Reduce card text size (`text-xs sm:text-sm`)
  - Reduce category text size
  - Ensure proper line clamping

- **Tablet:**
  - Use medium text sizes
  - Maintain readability

---

## 3. Horizontal Carousel (`HorizontalCarousel.tsx`)

### Current Issues:
- Arrow buttons may be too large on mobile
- Title and "See More" link need mobile optimization
- Scroll behavior needs touch optimization

### Changes Required:

#### 3.1 Arrow Buttons
- **Mobile:**
  - Hide arrows on mobile (rely on touch scrolling)
  - Or make arrows smaller (`p-2` instead of `p-3`)
  - Reduce icon size (`w-4 h-4`)

- **Tablet:**
  - Show arrows but make them slightly smaller
  - Use `p-2.5` for padding

#### 3.2 Title Section
- **Mobile:**
  - Stack title and "See More" vertically if needed
  - Reduce title size (`text-xl sm:text-2xl`)
  - Make "See More" link more prominent

- **Tablet:**
  - Keep horizontal layout
  - Use medium title sizes

#### 3.3 Touch Scrolling
- **Mobile & Tablet:**
  - Ensure smooth touch scrolling
  - Add momentum scrolling
  - Improve scrollbar hiding

---

## 4. App Download Section (`AppDownloadSection.tsx`)

### Current Issues:
- Phone mockups are hidden on mobile but layout needs adjustment
- QR code card needs mobile optimization
- Text sizes need responsive scaling

### Changes Required:

#### 4.1 Layout
- **Mobile:**
  - Stack content vertically (text above QR code)
  - Center align all content
  - Hide phone mockups completely
  - Reduce section padding (`py-8 sm:py-12`)

- **Tablet:**
  - Keep grid layout but stack if needed
  - Show phone mockups but make them smaller
  - Adjust positioning

#### 4.2 QR Code Card
- **Mobile:**
  - Reduce QR code size (`w-32 h-32 sm:w-40 sm:h-40`)
  - Center the card
  - Reduce padding

- **Tablet:**
  - Use medium size (`w-44 h-44 md:w-48 md:h-48`)

#### 4.3 Typography
- **Mobile:**
  - Reduce heading size (`text-2xl sm:text-3xl`)
  - Reduce description text
  - Make "Available on" text smaller

- **Tablet:**
  - Use medium sizes

#### 4.4 Phone Mockups
- **Mobile:**
  - Completely hidden (`hidden`)

- **Tablet:**
  - Show but reduce size (`w-40 h-[400px] md:w-56 md:h-[500px]`)
  - Adjust positioning to not overlap content

---

## 5. Reviews Section (`ReviewsSection.tsx`)

### Current Issues:
- Review cards may be too wide on mobile
- Arrow buttons need mobile optimization
- Card padding needs adjustment

### Changes Required:

#### 5.1 Card Width
- **Mobile:**
  - Use: `w-[260px] sm:w-[280px]` (instead of current `w-[280px] sm:w-[320px]`)
  - Ensure proper spacing

- **Tablet:**
  - Use: `w-[300px] md:w-[340px]`

#### 5.2 Card Content
- **Mobile:**
  - Reduce padding (`p-4 sm:p-6`)
  - Reduce star size (`w-3 h-3 sm:w-4 sm:h-4`)
  - Reduce text sizes
  - Reduce avatar size (`w-10 h-10 sm:w-12 sm:h-12`)

- **Tablet:**
  - Use medium padding and sizes

#### 5.3 Arrow Buttons
- **Mobile:**
  - Hide arrows (rely on touch scrolling)
  - Or make smaller

- **Tablet:**
  - Show arrows with medium size

---

## 6. Top Stats Section (`TopStatsSection.tsx`)

### Current Issues:
- Grid layout needs mobile optimization
- Text sizes need responsive scaling
- Spacing needs adjustment

### Changes Required:

#### 6.1 Grid Layout
- **Mobile:**
  - Single column layout (`grid-cols-1`)
  - Stack all stats vertically
  - Add proper spacing between items

- **Tablet:**
  - Use 3-column grid (`grid-cols-3`)
  - Maintain horizontal layout

#### 6.2 Typography
- **Mobile:**
  - Reduce main heading (`text-2xl sm:text-3xl`)
  - Reduce stat numbers (`text-3xl sm:text-4xl`)
  - Reduce description text

- **Tablet:**
  - Use medium sizes

#### 6.3 Spacing
- **Mobile:**
  - Reduce section padding (`py-8 sm:py-12`)
  - Reduce gap between stats (`gap-6 sm:gap-8`)

- **Tablet:**
  - Use medium padding and gaps

---

## 7. Business Promo Section (`BusinessPromoSection.tsx`)

### Current Issues:
- Grid layout needs mobile stacking
- Phone mockup positioning needs adjustment
- Calendar card needs mobile optimization

### Changes Required:

#### 7.1 Layout
- **Mobile:**
  - Stack content vertically (text above visuals)
  - Hide or significantly reduce phone mockup
  - Center align content

- **Tablet:**
  - Keep grid but adjust column widths
  - Reduce phone mockup size

#### 7.2 Calendar Card
- **Mobile:**
  - Reduce calendar size
  - Simplify grid (fewer days visible)
  - Reduce padding

- **Tablet:**
  - Use medium size
  - Maintain full calendar view

#### 7.3 Phone Mockup
- **Mobile:**
  - Hide completely or show very small version
  - Remove absolute positioning

- **Tablet:**
  - Reduce size (`w-32 h-[200px] md:w-40 md:h-[250px]`)
  - Adjust positioning to not overlap

#### 7.4 Typography
- **Mobile:**
  - Reduce heading (`text-2xl sm:text-3xl`)
  - Reduce description text
  - Make CTA button smaller

- **Tablet:**
  - Use medium sizes

---

## 8. City Directory Section (`CityDirectorySection.tsx`)

### Current Issues:
- Country carousel needs mobile optimization
- City columns need mobile stacking
- Arrow buttons need mobile handling

### Changes Required:

#### 8.1 Country Carousel
- **Mobile:**
  - Hide arrow buttons (use touch scrolling)
  - Reduce pill button size (`px-3 py-1.5`)
  - Reduce text size (`text-xs sm:text-sm`)
  - Add horizontal padding for scroll area

- **Tablet:**
  - Show arrows but smaller
  - Use medium button sizes

#### 8.2 City Columns
- **Mobile:**
  - Reduce column width (`w-[200px] sm:w-[240px]`)
  - Ensure proper spacing
  - Reduce city name size
  - Reduce service link sizes

- **Tablet:**
  - Use: `w-[260px] md:w-[300px]`

#### 8.3 Arrow Buttons
- **Mobile:**
  - Hide city carousel arrows
  - Rely on touch scrolling

- **Tablet:**
  - Show arrows with medium size

---

## 9. Section Spacing & Container

### Changes Required:

#### 9.1 PageSection Component
- **Mobile:**
  - Reduce default padding (`py-8 sm:py-12`)
  - Ensure consistent spacing

- **Tablet:**
  - Use medium padding (`py-12 md:py-16`)

#### 9.2 Container Component
- **Mobile:**
  - Reduce horizontal padding (`px-4 sm:px-6`)
  - Ensure content doesn't touch edges

- **Tablet:**
  - Use: `px-6 md:px-8`

---

## 10. Global Responsive Utilities

### Changes Required:

#### 10.1 Breakpoint Strategy
- **Mobile First:** Use `sm:` prefix for 640px+
- **Tablet:** Use `md:` prefix for 768px+
- **Desktop:** Use `lg:` prefix for 1024px+

#### 10.2 Typography Scale
- Create responsive typography utilities:
  - Mobile: Smaller base sizes
  - Tablet: Medium sizes
  - Desktop: Full sizes

#### 10.3 Spacing Scale
- Use consistent spacing:
  - Mobile: `gap-3`, `p-4`, `mb-4`
  - Tablet: `gap-4 md:gap-6`, `p-6 md:p-8`, `mb-6 md:mb-8`
  - Desktop: `gap-6 lg:gap-8`, `p-8 lg:p-12`

---

## 11. Touch & Interaction Optimizations

### Changes Required:

#### 11.1 Touch Targets
- **Mobile:**
  - Ensure all buttons are at least 44x44px
  - Increase tap target sizes
  - Add proper spacing between interactive elements

#### 11.2 Scrolling
- **Mobile & Tablet:**
  - Enable smooth scrolling
  - Add momentum scrolling
  - Hide scrollbars but maintain functionality
  - Improve touch scrolling performance

#### 11.3 Dropdowns & Modals
- **Mobile:**
  - Make dropdowns full-screen or large modals
  - Ensure proper touch interaction
  - Add close buttons

---

## 12. Performance Optimizations

### Changes Required:

#### 12.1 Image Optimization
- Use Next.js Image component with responsive sizes
- Implement lazy loading for below-fold content
- Use appropriate image sizes for each breakpoint

#### 12.2 Component Loading
- Lazy load carousels and heavy components
- Implement intersection observer for animations

---

## Implementation Priority

### Phase 1 (Critical - Mobile):
1. Hero Section search bar stacking
2. Venue card sizing
3. Container padding adjustments
4. Typography scaling

### Phase 2 (Important - Tablet):
1. Grid layout adjustments
2. Carousel arrow optimization
3. Section spacing
4. App download section layout

### Phase 3 (Enhancement):
1. Touch optimizations
2. Performance improvements
3. Animation refinements
4. Accessibility enhancements

---

## Testing Checklist

### Mobile (320px - 768px):
- [ ] Hero section stacks vertically
- [ ] Search bar is usable on mobile
- [ ] Cards are properly sized and scrollable
- [ ] Text is readable without zooming
- [ ] Buttons are easily tappable
- [ ] No horizontal scrolling
- [ ] All sections are accessible

### Tablet (768px - 1024px):
- [ ] Layout adapts to tablet width
- [ ] Cards display in appropriate grid
- [ ] Text sizes are comfortable
- [ ] Interactive elements are properly sized
- [ ] Carousels work smoothly
- [ ] No layout breaks

### Cross-Device:
- [ ] Smooth transitions between breakpoints
- [ ] Consistent spacing and alignment
- [ ] Proper image loading
- [ ] Performance is acceptable
- [ ] Touch interactions work correctly

---

## Files to Modify

1. `src/features/home/components/HeroSection.tsx`
2. `src/features/home/components/VenueCard.tsx`
3. `src/features/home/components/RecommendedSection.tsx`
4. `src/features/home/components/NewToFreshaSection.tsx`
5. `src/features/home/components/SpecialistsSection.tsx`
6. `src/features/home/components/AppDownloadSection.tsx`
7. `src/features/home/components/ReviewsSection.tsx`
8. `src/features/home/components/TopStatsSection.tsx`
9. `src/features/home/components/BusinessPromoSection.tsx`
10. `src/features/home/components/CityDirectorySection.tsx`
11. `src/components/carousel/HorizontalCarousel.tsx`
12. `src/components/layout/Container.tsx`
13. `src/components/layout/PageSection.tsx` (if exists)

---

## Estimated Implementation Time

- **Phase 1 (Mobile Critical):** 4-6 hours
- **Phase 2 (Tablet):** 3-4 hours
- **Phase 3 (Enhancements):** 2-3 hours
- **Testing & Refinement:** 2-3 hours

**Total:** 11-16 hours

---

## Notes

- Follow mobile-first approach
- Test on real devices when possible
- Ensure accessibility standards are maintained
- Keep performance in mind (avoid layout shifts)
- Maintain design consistency with reference images
- Use Tailwind's responsive utilities consistently

---

*End of Implementation Plan*

