# Fresha Clone - Next.js + Tailwind CSS

A modern, responsive clone of the Fresha website built with Next.js 14, TypeScript, and Tailwind CSS.

## Features

- ✨ Beautiful gradient hero section with search functionality
- 🎨 Modern, clean UI with smooth animations
- 📱 Fully responsive design
- 🎯 State management with Zustand
- 🎠 Interactive carousels for venue listings
- ⭐ Review sections with testimonials
- 📊 Stats section with impressive numbers
- 🏢 Business-focused sections
- 🌍 City directory browsing
- 🔍 Sticky header with navigation

## Tech Stack

- **Next.js 14** - React framework with App Router
- **TypeScript** - Type safety
- **Tailwind CSS** - Utility-first CSS framework
- **Zustand** - Lightweight state management
- **Lucide React** - Beautiful icon library

## Getting Started

### Prerequisites

- Node.js 18+ installed
- npm or yarn package manager

### Installation

1. Install dependencies:
```bash
npm install
```

2. Run the development server:
```bash
npm run dev
```

3. Open [http://localhost:3000](http://localhost:3000) in your browser.

### Build for Production

```bash
npm run build
npm start
```

## Project Structure

The project follows a feature-based architecture for scalability:

```
src/
├── app/                    # Next.js App Router routes
│   ├── layout.tsx         # Root layout with Header/Footer
│   ├── page.tsx           # Home page
│   ├── (auth)/            # Auth route group (login, signup)
│   ├── (customer)/        # Customer route group (profile)
│   ├── (marketing)/       # Marketing route group (business)
│   └── (venues)/          # Venues route group
│
├── components/            # Reusable UI components
│   ├── layout/            # Container, PageSection
│   ├── navigation/       # Header, Footer
│   ├── ui/               # Button, Card (design system)
│   ├── carousel/         # Carousel components
│   └── data-display/     # StarRating, etc.
│
├── features/             # Feature-based components
│   └── home/             # Home page features
│       ├── components/   # HeroSection, VenueCard, etc.
│       └── hooks/        # useHomepageData
│
├── lib/                  # Utility functions
├── hooks/                # Shared React hooks
├── config/               # Routes, constants
├── types/                # TypeScript types
├── store/                # Zustand state management
└── styles/               # Global styles
```

See [ARCHITECTURE.md](./ARCHITECTURE.md) for detailed architecture documentation.

## State Management

The project uses Zustand for state management:

- **Search Store**: Manages search form state (service, location, time)
- **Carousel Store**: Manages carousel scroll positions

## Customization

### Colors

Edit `tailwind.config.ts` to customize the color scheme.

### Content

Update the mock data in `src/features/home/hooks/useHomepageData.ts` to customize venue listings and content.

### Images

Replace placeholder images with your own. The project is configured to work with:
- Unsplash images
- Local images in the `public` folder

## License

This is a clone project for educational purposes.

