module.exports = [
"[project]/sigitechnologies.cloud/src/lib/api/fetcher-server.ts [app-rsc] (ecmascript)", ((__turbopack_context__) => {
"use strict";

/**
 * Server-side API Fetcher
 * ONLY use in Server Components, Server Actions, Route Handlers
 */ __turbopack_context__.s([
    "ApiError",
    ()=>ApiError,
    "serverFetcher",
    ()=>serverFetcher
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$dist$2f$compiled$2f$server$2d$only$2f$empty$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/dist/compiled/server-only/empty.js [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$env$2e$ts__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/src/config/env.ts [app-rsc] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$headers$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/sigitechnologies.cloud/node_modules/next/headers.js [app-rsc] (ecmascript)");
;
;
;
class ApiError extends Error {
    status;
    message;
    statusCode;
    error;
    constructor(status, message, statusCode, error){
        super(message), this.status = status, this.message = message, this.statusCode = statusCode, this.error = error;
        this.name = "ApiError";
    }
}
/**
 * Normalize API response data to camelCase
 */ function normalizeToCamelCase(obj) {
    if (obj === null || obj === undefined) {
        return obj;
    }
    if (Array.isArray(obj)) {
        return obj.map(normalizeToCamelCase);
    }
    if (typeof obj !== "object") {
        return obj;
    }
    const normalized = {};
    for (const [key, value] of Object.entries(obj)){
        const camelKey = key.replace(/_([a-z])/g, (_, letter)=>letter.toUpperCase());
        normalized[camelKey] = normalizeToCamelCase(value);
    }
    return normalized;
}
async function serverFetcher(endpoint, options = {}) {
    const { requireAuth = true, headers: customHeaders = {}, ...fetchOptions } = options;
    const url = `${__TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$src$2f$config$2f$env$2e$ts__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["API_BASE_URL"]}${endpoint}`;
    // Build headers
    const headersObj = {
        "Content-Type": "application/json",
        Accept: "application/json"
    };
    // Add custom headers if provided as a plain object
    if (customHeaders && typeof customHeaders === "object" && !Array.isArray(customHeaders) && !(customHeaders instanceof Headers)) {
        Object.assign(headersObj, customHeaders);
    }
    // Add authentication token from cookies
    if (requireAuth) {
        const cookieStore = await (0, __TURBOPACK__imported__module__$5b$project$5d2f$sigitechnologies$2e$cloud$2f$node_modules$2f$next$2f$headers$2e$js__$5b$app$2d$rsc$5d$__$28$ecmascript$29$__["cookies"])();
        const token = cookieStore.get("access_token")?.value || null;
        if (token) {
            headersObj.accessToken = token;
        }
    }
    // Convert to HeadersInit for fetch
    const headers = headersObj;
    // Add device token (skip on server - device tokens are client-only)
    // Device tokens are generated per device/browser, not per server request
    // If needed, generate a server-side session token instead
    try {
        console.log("[serverFetcher] Making request to:", url);
        console.log("[serverFetcher] Headers:", JSON.stringify(headers, null, 2));
        console.log("[serverFetcher] Method:", fetchOptions.method || "GET");
        const response = await fetch(url, {
            ...fetchOptions,
            headers
        });
        console.log("[serverFetcher] Response status:", response.status);
        console.log("[serverFetcher] Response statusText:", response.statusText);
        console.log("[serverFetcher] Response headers:", Object.fromEntries(response.headers.entries()));
        // Handle non-JSON responses
        const contentType = response.headers.get("content-type");
        console.log("[serverFetcher] Content-Type:", contentType);
        if (!contentType?.includes("application/json")) {
            const text = await response.text();
            console.error("[serverFetcher] Non-JSON response body:", text.substring(0, 500));
            throw new ApiError("0", `Unexpected response type: ${contentType}`, response.status);
        }
        const data = await response.json();
        console.log("[serverFetcher] Response data status:", data.status);
        console.log("[serverFetcher] Response data message:", data.message);
        console.log("[serverFetcher] Response has data:", !!data.data);
        // Check if status indicates an error
        if (data.status !== "1" && data.status !== "2") {
            console.error("[serverFetcher] API returned error status:", data.status);
            console.error("[serverFetcher] Error message:", data.message);
            console.error("[serverFetcher] Error field:", data.error);
            throw new ApiError(data.status, data.message, response.status, data.error);
        }
        // Normalize and return data
        console.log("[serverFetcher] Normalizing response data");
        const normalizedData = normalizeToCamelCase(data.data);
        console.log("[serverFetcher] Normalized data keys:", normalizedData && typeof normalizedData === "object" ? Object.keys(normalizedData) : "N/A");
        return normalizedData;
    } catch (error) {
        // Re-throw ApiError as-is
        if (error instanceof ApiError) {
            throw error;
        }
        // Handle network errors
        if (error instanceof TypeError && error.message === "Failed to fetch") {
            throw new ApiError("0", "Network error. Please check your connection.", 0);
        }
        // Handle other errors
        throw new ApiError("0", error instanceof Error ? error.message : "An unexpected error occurred", 500);
    }
}
}),
];

//# sourceMappingURL=sigitechnologies_cloud_src_lib_api_fetcher-server_ts_7f49174c._.js.map